/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.awt.Component;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.DomNode;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.graph.DasCanvasComponent;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class BindingSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");
    public static final Converter toStringConverter = new Converter(){
        Class c = null;
        Object instance;

        public Object convertForward(Object value) {
            this.instance = value;
            if (this.c == null) {
                this.c = this.instance.getClass();
            }
            if (this.c == Color.class) {
                return ColorUtil.nameForColor((Color)((Color)value));
            }
            return value.toString();
        }

        public Object convertReverse(Object value) {
            if (this.c.isAssignableFrom(Datum.class)) {
                try {
                    return DatumUtil.parse((String)((String)value));
                }
                catch (ParseException ex) {
                    return this.instance;
                }
            }
            if (this.c.isAssignableFrom(DatumRange.class)) {
                try {
                    return DatumRangeUtil.parseTimeRange((String)((String)value));
                }
                catch (ParseException ex) {
                    return this.instance;
                }
            }
            if (this.c.isAssignableFrom(Color.class)) {
                return ColorUtil.decodeColor((String)((String)value));
            }
            return value.toString();
        }
    };
    final Map<Object, List<BindingImpl>> implBindingContexts = new HashMap<Object, List<BindingImpl>>();

    protected BindingSupport() {
    }

    private PropertyChangeListener propListener(Object p, Method setter, Method getter, Converter c, boolean forward, String srcProp, String pprop) {
        return new MyPropChangeListener(p, setter, getter, c, forward, srcProp, pprop);
    }

    public String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private void lookupGetterSetter(Object src, String propName, BindingImpl bi) {
        try {
            Class<?> c = src.getClass();
            PropertyDescriptor pd = new PropertyDescriptor(propName, c);
            Method setter = pd.getWriteMethod();
            Method getter = pd.getReadMethod();
            if (src == bi.src) {
                bi.srcSetter = setter;
                bi.srcGetter = getter;
            } else {
                bi.dstSetter = setter;
                bi.dstGetter = getter;
            }
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(DomNode src, String srcProp, Object dst, String dstProp, Converter c) {
        PropertyChangeListener dstListener;
        if (srcProp.contains(".")) {
            throw new IllegalArgumentException("src property name cannot contain periods: " + srcProp);
        }
        if (dstProp.contains(".")) {
            throw new IllegalArgumentException("dst property name cannot contain periods: " + dstProp);
        }
        BindingImpl bi = new BindingImpl();
        bi.dst = dst;
        bi.src = src;
        bi.srcProp = srcProp;
        bi.dstProp = dstProp;
        this.lookupGetterSetter(src, srcProp, bi);
        this.lookupGetterSetter(dst, dstProp, bi);
        if (bi.dstSetter == null) {
            throw new NullPointerException("unable to find setter for " + dstProp);
        }
        try {
            Object val = bi.srcGetter.invoke((Object)src, new Object[0]);
            if (c != null) {
                val = c.convertForward(val);
            }
            try {
                bi.dstSetter.invoke(dst, val);
            }
            catch (IllegalArgumentException ex) {
                logger.info("IllegalArgumentException in bind");
            }
        }
        catch (IllegalArgumentException ex) {
            String msg = String.format("failed to bind %s.%s to %s.%s", src, srcProp, dst, dstProp);
            throw new RuntimeException(msg, ex);
        }
        catch (IllegalAccessException | RuntimeException | InvocationTargetException ex) {
            String msg = String.format("failed to bind %s.%s to %s.%s", src, srcProp, dst, dstProp);
            throw new RuntimeException(msg, ex);
        }
        PropertyChangeListener srcListener = this.propListener(dst, bi.dstSetter, bi.dstGetter, c, true, srcProp, dstProp);
        src.addPropertyChangeListener(srcProp, srcListener);
        bi.dstListener = dstListener = this.propListener(src, bi.srcSetter, bi.srcGetter, c, false, dstProp, srcProp);
        bi.srcListener = srcListener;
        try {
            Method apcl = dst.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            apcl.invoke(dst, dstProp, dstListener);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            List<BindingImpl> list = this.implBindingContexts.get(src);
            if (list == null) {
                list = new ArrayList<BindingImpl>();
                this.implBindingContexts.put(src, list);
            }
            list.add(bi);
            logger.log(Level.FINE, "adding binding to BindingImpls for {0} size={1} {2}", new Object[]{src, list.size(), src.hashCode()});
        }
    }

    public boolean isBound(Object node, String property) {
        List<BindingImpl> list = this.implBindingContexts.get(node);
        if (list == null) {
            return false;
        }
        for (BindingImpl bi : list) {
            if (bi.dst == node && bi.dstProp.equals(property)) {
                return true;
            }
            if (bi.src != node || !bi.srcProp.equals(property)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(DomNode master) {
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            List<BindingImpl> list = this.implBindingContexts.get(master);
            if (list == null) {
                return;
            }
            for (BindingImpl bi : list) {
                try {
                    Method apcl = bi.dst.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    apcl.invoke(bi.dst, bi.dstProp, bi.dstListener);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                bi.src.removePropertyChangeListener(bi.srcProp, bi.srcListener);
            }
            list.clear();
            this.implBindingContexts.remove(master);
            logger.log(Level.FINE, "remove binding to BindingImpls for {0} size={1} {2}", new Object[]{master, list.size(), this.implBindingContexts.size()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(DomNode master, String property, Object dst, String dstProp) {
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            List<BindingImpl> list = this.implBindingContexts.get(master);
            if (list == null) {
                return;
            }
            ArrayList<BindingImpl> list2 = new ArrayList<BindingImpl>(list);
            for (BindingImpl bi : list) {
                if (!bi.srcProp.equals(property) || bi.dst != dst || !bi.dstProp.equals(dstProp)) continue;
                try {
                    Method apcl = bi.dst.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    apcl.invoke(bi.dst, bi.dstProp, bi.dstListener);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                bi.src.removePropertyChangeListener(bi.srcProp, bi.srcListener);
                list2.remove(bi);
            }
            logger.log(Level.FINE, "remove binding to BindingImpls for {0} size={1} {2}", new Object[]{master, list.size(), this.implBindingContexts.size()});
            if (list2.isEmpty()) {
                this.implBindingContexts.remove(master);
            } else {
                this.implBindingContexts.put(master, list2);
            }
        }
    }

    public String toString() {
        return "== BindingSupport: ==\n" + this.implBindingContexts.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatus() {
        HashMap<Object, List<BindingImpl>> copy;
        int total = 0;
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            copy = new HashMap<Object, List<BindingImpl>>(this.implBindingContexts);
            for (Map.Entry entry : copy.entrySet()) {
                entry.setValue(new ArrayList((Collection)entry.getValue()));
            }
        }
        ArrayList keys = new ArrayList(copy.keySet());
        Collections.sort(keys, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof DomNode && o2 instanceof DomNode) {
                    return ((DomNode)o1).getId().compareTo(((DomNode)o2).getId());
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (Map.Entry entry : keys) {
            List value = (List)copy.get(entry);
            int s = value.size();
            System.err.println("--- " + entry + " (" + s + " bindings) ---");
            total += s;
            for (BindingImpl l : value) {
                System.err.println(l);
            }
        }
        System.err.println("\nBindingSupport contains " + copy.size() + " groups of " + total + " bindings.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalBindings() {
        HashMap<Object, List<BindingImpl>> copy;
        int total = 0;
        Map<Object, List<BindingImpl>> map = this.implBindingContexts;
        synchronized (map) {
            copy = new HashMap<Object, List<BindingImpl>>(this.implBindingContexts);
            for (Map.Entry entry : copy.entrySet()) {
                entry.setValue(new ArrayList((Collection)entry.getValue()));
            }
        }
        for (Map.Entry entry : copy.entrySet()) {
            int n = ((List)entry.getValue()).size();
            total += n;
        }
        System.err.println("\nBindingSupport contains " + copy.size() + " groups of " + total + " bindings.");
        return total;
    }

    private static class MyPropChangeListener
    implements PropertyChangeListener {
        final Object p;
        final Method setter;
        final Method getter;
        final Converter c;
        final boolean forward;
        final String srcProp;
        final String pprop;

        private MyPropChangeListener(Object p, Method setter, Method getter, Converter c, boolean forward, String srcProp, String pprop) {
            this.p = p;
            this.setter = setter;
            this.getter = getter;
            this.c = c;
            this.forward = forward;
            this.srcProp = srcProp;
            this.pprop = pprop;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
            try {
                if (this.c == null) {
                    Object oldValue = this.getter.invoke(this.p, new Object[0]);
                    if (oldValue == null) {
                        System.err.println("oldValue is null!!!");
                    }
                    if (oldValue != null && oldValue.equals(evt.getNewValue())) {
                        return;
                    }
                    if (new Exception().getStackTrace().length > 300) {
                        System.err.println("setter: " + this.setter);
                        System.err.println("old:" + evt.getOldValue() + "  new:" + evt.getNewValue());
                        System.err.println("this is that bad state, where bindings get us into a infinite loop!");
                    } else {
                        this.setter.invoke(this.p, evt.getNewValue());
                    }
                } else {
                    if (Thread.currentThread().getStackTrace().length > 200) {
                        System.err.println("Problem detected in stack trace, circular call indicated by stackTraceLength>200");
                        return;
                    }
                    if (this.forward) {
                        this.setter.invoke(this.p, this.c.convertForward(evt.getNewValue()));
                    } else {
                        this.setter.invoke(this.p, this.c.convertReverse(evt.getNewValue()));
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class BindingImpl {
        PropertyChangeListener srcListener;
        PropertyChangeListener dstListener;
        DomNode src;
        Object dst;
        String dstProp;
        String srcProp;
        Method dstSetter;
        Method srcSetter;
        Method dstGetter;
        Method srcGetter;

        private BindingImpl() {
        }

        public String toString() {
            if (this.dst instanceof DomNode) {
                return this.src + "." + this.srcProp + " \u2194\t" + this.dst + "." + this.dstProp;
            }
            if (this.dst instanceof DasCanvasComponent) {
                return this.src + "." + this.srcProp + " \u2194\t\"" + ((DasCanvasComponent)this.dst).getDasName() + "\"." + this.dstProp;
            }
            if (this.dst instanceof Component) {
                return this.src + "." + this.srcProp + " \u2194\t\"" + ((Component)this.dst).getName() + "\"." + this.dstProp;
            }
            return this.src + "." + this.srcProp + " \u2194\t\"" + this.dst + "\"." + this.dstProp;
        }
    }
}

